// This file contains the DCC and LED definitions.
//
// It was automatically generated by the program Prog_Generator_MobaLedLib.xlsm Ver. 3.5.0C1      by Hardi
// File creation: 29.12.2025 16:24:26
// (Attention: The display in the Arduino IDE is not updated if Options/External Editor is disabled)

#ifndef __LEDS_AUTOPROG_H__
#define __LEDS_AUTOPROG_H__

#ifndef CONFIG_ONLY
#ifndef ARDUINO_RASPBERRY_PI_PICO
#ifndef FASTLED_ESP32_I2S
#define FASTLED_INTERNAL       // Disable version number message in FastLED library (looks like an error)
#endif
#include <FastLED.h>           // The FastLED library must be installed in addition if you got the error message "..fatal error: FastLED.h: No such file or directory"
                               // Arduino IDE: Sketch / Include library / Manage libraries                    Deutsche IDE: Sketch / Bibliothek einbinden / Bibliothek verwalten
                               //              Type "FastLED" in the "Filter your search..." field                          "FastLED" in das "Grenzen Sie ihre Suche ein" Feld eingeben
                               //              Select the entry and click "Install"                                         Gefundenen Eintrag auswaehlen und "Install" anklicken
#else
#include <PicoFastLED.h>       // Juergens minimum version or FastLED for Raspberry Pico
#endif
#endif // CONFIG_ONLY

#include <MobaLedLib.h>

#define START_MSG "LEDs_AutoProg Ver 3: ESP32 3.5.0C1 29.12.25 16:24"

#define TWO_BUTTONS_PER_ADDRESS 1      // Two buttons (Red/Green) are used (DCC/LNet/CAN)
#ifdef NUM_LEDS
  #warning "'NUM_LEDS' definition in the main program is replaced by the included 'LEDs_AutoProg.h' with 248"
  #undef NUM_LEDS
#endif

#define NUM_LEDS 248                   // Number of LEDs (Maximal 256 RGB LEDs could be used)

#define LEDS_PER_CHANNEL ",240,8"

#define USE_PROTOCOL_DCC

#define RECEIVE_LED_COLOR_PER_RS232

#define GEN_BUTTON_RELEASE
#define GEN_BUTTON_RELEASE_COM GEN_OFF
#define USE_EXT_ADDR
#define USE_RS232_OR_SPI_AS_INPUT 1     // Use the RS232 or SPI Input to read DCC/LNet/SX commands from the second Arduino and from the PC (The SPI is only used if enabled with USE_SPI_COM)
#define ADDR_OFFSET 0

#define ADDR_MSK  0x3FFF  // 14 Bits are used for the Address

#define S_ONOFF   (uint16_t)0
#define B_RED     (uint16_t)(1<<14)
#define B_GREEN   (uint16_t)(2<<14)
#define O_RET_MSG (uint16_t)(3<<14)    // Return messages (Rueckmelder)
#define B_TAST    B_RED


typedef struct
    {
    uint16_t AddrAndTyp; // Addr range: 0..16383. The upper two bytes are used for the type
    uint8_t  InCnt;
    } __attribute__ ((packed)) Ext_Addr_T;

// Definition of external adresses
#ifdef CONFIG_ONLY
const Ext_Addr_T Ext_Addr[] __attribute__ ((section (".MLLAddressConfig"))) =
#else
const PROGMEM Ext_Addr_T Ext_Addr[] =
#endif
         { // Addr & Typ    InCnt
           { 10   + B_GREEN,   1 },      // Minuten Offset
           { 11   + B_GREEN,   1 },      // Minuten erhhen wenn "#define RTC_DEBUG"
           { 12   + B_GREEN,   1 },      // Stunden erhhen wenn "#define RTC_DEBUG"
           { 13   + B_GREEN,   1 },      // Wochentag erhhen wenn "#define RTC_DEBUG"
           { 14   + B_GREEN,   1 },      // Temperatur erhhen wenn "#define RTC_DEBUG"
         };


// Input channel defines for local inputs and expert users
#define INCH_DCC_10_GREEN       0      // Minuten Offset
#define INCH_DCC_11_GREEN       1      // Minuten erhhen wenn "#define RTC_DEBUG"
#define INCH_DCC_12_GREEN       2      // Stunden erhhen wenn "#define RTC_DEBUG"
#define INCH_DCC_13_GREEN       3      // Wochentag erhhen wenn "#define RTC_DEBUG"
#define INCH_DCC_14_GREEN       4      // Temperatur erhhen wenn "#define RTC_DEBUG"


//*** Direct connected switches ***

#define START_SWITCHES_D  5                                        // Define the start number for the first mainboard switch
#define SwitchD1                5
#define SwitchD2                6

//*** Output Channels ***
#define START_VARIABLES   7                                        // Define the start number for the variables.
#define Zeit0                   7
#define Zeit1                   8
#define Zeit2                   9
#define Zeit3                   10
#define Birthday1               11
#define Birthday2               12
#define Birthday3               13
#define Birthday4               14
#define EventTxt1               15
#define EventTxt2               16
#define EventTxt3               17
#define EventTxt4               18
#define UnusedVar0              19
#define MinOffs0                20
#define MinOffs1                21
#define MinOffs2                22
#define MinOffs3                23
#define MinOffs4                24
#define Minutes0                25
#define Minutes1                26
#define Minutes2                27
#define Minutes3                28
#define FUENF                   29
#define ZEHN                    30
#define ZWANZIG                 31
#define DREI                    32
#define VIERTEL                 33
#define VOR                     34
#define NACH                    35
#define HALB                    36
#define VolleStd                37
#define Hours0                  38
#define Hours1                  39
#define Hours2                  40
#define Hours3                  41
#define STD_EL                  42
#define STD_F                   43
#define STD_UENF                44
#define STD_EIN                 45
#define STD_ZWEI                46
#define STD_DREI                47
#define STD_VIER                48
#define STD_SECHS               49
#define STD_ACHT                50
#define STD_ZWOELF              51
#define STD_ZEH                 52
#define STD_N                   53
#define STD_EUN                 54
#define STD_SIEBEN              55
#define STD_S                   56
#define Uhr_Txt                 57
#define Wochentag0              58
#define Wochentag1              59
#define Wochentag2              60
#define Wochentag3              61
#define Wochentag4              62
#define Wochentag5              63
#define Wochentag6              64
#define Wochentag7              65
#define O_Do_or_Mo              66
#define Temp0                   67
#define Temp1                   68
#define Temp2                   69
#define Temp3                   70
#define Temp4                   71
#define Temp5                   72
#define Temp6                   73
#define Temp7                   74
#define Temp8                   75
#define Temp9                   76
#define Temp10                  77
#define Temp11                  78
#define Temp12                  79

const PROGMEM uint8_t SwitchD_Pins[] = { 12,26,25 };               // Array of pins which read switches 'D'
#define SWITCH_D_INP_CNT sizeof(SwitchD_Pins)


#define START_SEND_INPUTS 5                                        // Start address of all switches/variables
#define TOTAL_SEND_INPUTS 75                                       // Number of used switches/variables
#define TOTAL_SWITCHES_A  0                                        // Number of used inputs for analog keyboard
#define TOTAL_SWITCHES_B  0                                        // Number of used inputs for keyboard 1
#define TOTAL_SWITCHES_C  0                                        // Number of used inputs for keyboard 2
#define TOTAL_SWITCHES_D  2                                        // Number of used inputs for main board switches
#define TOTAL_VARIABLES   73                                       // Number of used variables
/*********************/
#define SETUP_FASTLED()                                                      \
/*********************/                                                      \
  CLEDController& controller0 = FastLED.addLeds<NEOPIXEL, 27>(leds+  0,240); \
  CLEDController& controller1 = FastLED.addLeds<NEOPIXEL, 32>(leds+240,  8); \
                                                                             \
  controller0.clearLeds(256);                                                \
  controller1.clearLeds(256);                                                \
  FastLED.setDither(DISABLE_DITHER);       // avoid sending slightly modified brightness values
/*End*/

#define USE_ADDITIONAL_SETUP_PROC                                  // Activate the usage of the Additional_Setup_Proc()

//--------------------------
void Additional_Setup_Proc()
//--------------------------
{

  for (uint8_t i = 0; i < SWITCH_D_INP_CNT; i++)
    pinMode(pgm_read_byte_near(&SwitchD_Pins[i]), INPUT_PULLUP);
}

/****************************/
#define Additional_Loop_Proc() \
/****************************/ \
{                              \
  for (uint8_t i = 0; i < 2; i++) \
      MobaLedLib.Set_Input(SwitchD1 + i, !digitalRead(pgm_read_byte_near(&SwitchD_Pins[i])));\
}
// ----- LED to Var -----
  #define USE_LED_TO_VAR

  #define T_EQUAL_THEN     0
  #define T_NOT_EQUAL_THEN 1
  #define T_LESS_THEN      2
  #define T_GREATER_THAN   3
  #define T_BIN_MASK       4
  #define T_NOT_BIN_MASK   5

  typedef struct
      {
      uint8_t  Var_Nr;
#ifdef LONG_LED_ADDR
      uint16_t LED_Nr;
#else
      uint8_t  LED_Nr;
#endif
      uint8_t  Offset_and_Typ; // ---oottt    Offset: 0..2
      uint8_t  Val;
      } __attribute__ ((packed)) LED2Var_Tab_T;

#ifdef CONFIG_ONLY
  const LED2Var_Tab_T LED2Var_Tab[] __attribute__ ((section (".MLLL2VConfig"))) =
#else
  const PROGMEM LED2Var_Tab_T LED2Var_Tab[] =
#endif
      {
        // Var name           LED_Nr LED Offset   Typ                Compare value
        { FUENF,              240,   (0   << 3) | T_GREATER_THAN,    0   },
        { ZEHN,               240,   (1   << 3) | T_GREATER_THAN,    0   },
        { ZWANZIG,            240,   (2   << 3) | T_GREATER_THAN,    0   },
        { DREI,               241,   (0   << 3) | T_GREATER_THAN,    0   },
        { VIERTEL,            241,   (1   << 3) | T_GREATER_THAN,    0   },
        { VOR,                241,   (2   << 3) | T_GREATER_THAN,    0   },
        { NACH,               242,   (0   << 3) | T_GREATER_THAN,    0   },
        { HALB,               242,   (1   << 3) | T_GREATER_THAN,    0   },
        { VolleStd,           242,   (2   << 3) | T_GREATER_THAN,    0   },
        { STD_EL,             243,   (0   << 3) | T_GREATER_THAN,    0   },
        { STD_F,              243,   (1   << 3) | T_GREATER_THAN,    0   },
        { STD_UENF,           243,   (2   << 3) | T_GREATER_THAN,    0   },
        { STD_EIN,            244,   (0   << 3) | T_GREATER_THAN,    0   },
        { STD_ZWEI,           244,   (1   << 3) | T_GREATER_THAN,    0   },
        { STD_DREI,           244,   (2   << 3) | T_GREATER_THAN,    0   },
        { STD_VIER,           245,   (0   << 3) | T_GREATER_THAN,    0   },
        { STD_SECHS,          245,   (1   << 3) | T_GREATER_THAN,    0   },
        { STD_ACHT,           245,   (2   << 3) | T_GREATER_THAN,    0   },
        { STD_ZWOELF,         246,   (0   << 3) | T_GREATER_THAN,    0   },
        { STD_ZEH,            246,   (1   << 3) | T_GREATER_THAN,    0   },
        { STD_N,              246,   (2   << 3) | T_GREATER_THAN,    0   },
        { STD_EUN,            247,   (0   << 3) | T_GREATER_THAN,    0   },
        { STD_SIEBEN,         247,   (1   << 3) | T_GREATER_THAN,    0   },
      };




//*******************************************************************
// *** Configuration array which defines the behavior of the LEDs ***
MobaLedLib_Configuration()
  {
  #define RTC_STATUS_LED0                                                                                     /* Verwende die erste LED als Status LED                                                                                                                                                       */
  // Next_LED(1)                                                                                              /* Die erste LED wird als Status LED von | RealTimeClockMLX benutzt darum muss sie bersprungen werden und darf nicht als HeartBeat benutzt werden.                                            */
  #define RTC_SHOW_BAT_EMPTY 1                                                                                /* Wenn die Batterie der RTC leer ist blinkt die status LED schnell. Das funktioniert aber noch nicht so richtig. Darum muss man es explizit anschalten.                                       */
  #define LED_BUILTIN 99                                                                                      /* Disable warning from InfraredMLX                                                                                                                                                            */
  #undef USE_RS232_OR_SPI_AS_INPUT                                                                            /* To be able to set the time/date per RS232                                                                                                                                                   */
  #ifdef RECEIVE_LED_COLOR_PER_RS232                                                                          /* Disable Color testing because it is normaly it is enabled in the config line "Aktiviere LED Farbtest Mode "                                                                                 */
    #undef RECEIVE_LED_COLOR_PER_RS232                                                                        /*     "                                                                                                                                                                                       */
  #endif                                                                                                      /*     "                                                                                                                                                                                       */
  // Set_LEDNr(18)                                                                                            /* Blaulicht wenn Geburtstag                                                                                                                                                                   */
  BlueLight1(18, C3, Zeit3)                                                                                   /* Excel row 117                                                                                                                                                                               */
  // Set_LEDNr(31)                                                                                            /* Excel row 118                                                                                                                                                                               */
  BlueLight2(31, C3, Zeit3)                                                                                   /* Excel row 119                                                                                                                                                                               */
  // Set_LEDNr(33)                                                                                            /* Excel row 121                                                                                                                                                                               */
  New_HSV_Group()                                                                                             /* Excel row 122                                                                                                                                                                               */
  APatternT2(33,192,SI_1,1,0,255,0,PM_HSV,60 Sek,0 ms,1)                                                      /* Farbe verndern. Wenn Zeiten grer als 65 Sekunden verwendet werden sollen, dann muss PF_SLOW hinzugefgt werden und die Zeit durch 16 geteilt werden.                                     */
  APatternT1(33,194,SI_0,1,0,1,0,PM_HSV|PF_EASEINOUT,1 Sek,1)                                                 /* Die Erste LED flackert ;-(                                                                                                                                                                  */
  // Set_LEDNr(37)                                                                                            /* Excel row 125                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* IS(T)                                                                                                                                                                                       */
  Bin_InCh_to_TmpVar(Zeit1, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(37,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyNLEDs(2, 38, Zeit2, 37)                                                                                 /* (IS)T                                                                                                                                                                                       */
  // Set_LEDNr(45)                                                                                            /* Excel row 128                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* E(S)                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Zeit1, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(45,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyLED(46, Zeit2, 45)                                                                                      /* (E)S                                                                                                                                                                                        */
  // Set_LEDNr(18)                                                                                            /* Excel row 135                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* LED 18 Links oben                                                                                                                                                                           */
  Bin_InCh_to_TmpVar(MinOffs1, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(18,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  // Set_LEDNr(31)                                                                                            /* Excel row 137                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* LED 31 rechts oben                                                                                                                                                                          */
  Bin_InCh_to_TmpVar(MinOffs2, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(31,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  // Set_LEDNr(226)                                                                                           /* Excel row 139                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* LED 226 rechts unten                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(MinOffs3, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(226,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Set_LEDNr(239)                                                                                           /* Excel row 141                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* LED 239 links unten                                                                                                                                                                         */
  Bin_InCh_to_TmpVar(MinOffs4, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(239,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* Minuten viertel vor (Nur eine der 3 Zeilen darf aktiv sein)                                                                                                                                 */
  Bin_InCh_to_TmpVar(Minutes0, 4)                                                                             /*     "                                                                                                                                                                                       */
  PatternT1(240,128,SI_LocalVar,9,0,255,0,0,1 Sec,0,131,8,129,34,42,20,160,96,36,96,136,8,1  ,63,191,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                                                                       */
  // LED_to_Var(FUENF, 0, >, 0)                                                                               /* Excel row 148                                                                                                                                                                               */
  // LED_to_Var(ZEHN, 1, >, 0)                                                                                /* Excel row 149                                                                                                                                                                               */
  // LED_to_Var(ZWANZIG, 2, >, 0)                                                                             /* Excel row 150                                                                                                                                                                               */
  // LED_to_Var(DREI, 3, >, 0)                                                                                /* Excel row 151                                                                                                                                                                               */
  // LED_to_Var(VIERTEL, 4, >, 0)                                                                             /* Excel row 152                                                                                                                                                                               */
  // LED_to_Var(VOR, 5, >, 0)                                                                                 /* Excel row 153                                                                                                                                                                               */
  // LED_to_Var(NACH, 6, >, 0)                                                                                /* Excel row 154                                                                                                                                                                               */
  // LED_to_Var(HALB, 7, >, 0)                                                                                /* Excel row 155                                                                                                                                                                               */
  // LED_to_Var(VolleStd, 8, >, 0)                                                                            /* Excel row 156                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* Stunden normale Zeile                                                                                                                                                                       */
  Bin_InCh_to_TmpVar(Hours0, 4)                                                                               /*     "                                                                                                                                                                                       */
  PatternT1(243,64,SI_LocalVar,14,0,255,0,0,1 Sec,0,0,2,0,1,128,0,64,128,1,0,8,0,128,0,1,0,6,192,12,0,0,2  ,63,191,191,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                                                     */
  // LED_to_Var(STD_EL    , 0, >, 0)                                                                          /* Excel row 163                                                                                                                                                                               */
  // LED_to_Var(STD_F     , 1, >, 0)                                                                          /* Excel row 164                                                                                                                                                                               */
  // LED_to_Var(STD_UENF  , 2, >, 0)                                                                          /* Excel row 165                                                                                                                                                                               */
  // LED_to_Var(STD_EIN   , 3, >, 0)                                                                          /* Excel row 166                                                                                                                                                                               */
  // LED_to_Var(STD_ZWEI  , 4, >, 0)                                                                          /* Excel row 167                                                                                                                                                                               */
  // LED_to_Var(STD_DREI  , 5, >, 0)                                                                          /* Excel row 168                                                                                                                                                                               */
  // LED_to_Var(STD_VIER  , 6, >, 0)                                                                          /* Excel row 169                                                                                                                                                                               */
  // LED_to_Var(STD_SECHS , 7, >, 0)                                                                          /* Excel row 170                                                                                                                                                                               */
  // LED_to_Var(STD_ACHT  , 8, >, 0)                                                                          /* Excel row 171                                                                                                                                                                               */
  // LED_to_Var(STD_ZWOELF, 9, >, 0)                                                                          /* Excel row 172                                                                                                                                                                               */
  // LED_to_Var(STD_ZEH   , 10, >, 0)                                                                         /* Excel row 173                                                                                                                                                                               */
  // LED_to_Var(STD_N     , 11, >, 0)                                                                         /* Excel row 174                                                                                                                                                                               */
  // LED_to_Var(STD_EUN   , 12, >, 0)                                                                         /* Excel row 175                                                                                                                                                                               */
  // LED_to_Var(STD_SIEBEN, 13, >, 0)                                                                         /* Excel row 176                                                                                                                                                                               */
  // Set_LEDNr(51)                                                                                            /* Excel row 178                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (Z)EHN                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(ZEHN, 1)                                                                                 /*     "                                                                                                                                                                                       */
  APatternT1(51,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 52, Zeit2, 51)                                                                                 /* Z(EHN)                                                                                                                                                                                      */
  // Set_LEDNr(56)                                                                                            /* Excel row 182                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (Z)WANZIG                                                                                                                                                                                   */
  Bin_InCh_to_TmpVar(ZWANZIG, 1)                                                                              /*     "                                                                                                                                                                                       */
  APatternT1(56,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyNLEDs(6, 57, Zeit2, 56)                                                                                 /* Z(WANZIG)                                                                                                                                                                                   */
  // Set_LEDNr(67)                                                                                            /* Excel row 186                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* VIERTE(L)                                                                                                                                                                                   */
  Bin_InCh_to_TmpVar(VIERTEL, 1)                                                                              /*     "                                                                                                                                                                                       */
  APatternT1(67,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyNLEDs(6, 68, Zeit2, 67)                                                                                 /* (VIERTE)L                                                                                                                                                                                   */
  // Activation: Binary                                                                                       /* DRE(I)                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(DREI, 1)                                                                                 /*     "                                                                                                                                                                                       */
  APatternT1(74,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 75, Zeit2, 74)                                                                                 /* (DRE)I                                                                                                                                                                                      */
  // Set_LEDNr(83)                                                                                            /* Excel row 193                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (F)NF                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(FUENF, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(83,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 84, Zeit2, 83)                                                                                 /* F(NF)                                                                                                                                                                                      */
  // Set_LEDNr(88)                                                                                            /* Excel row 197                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (V)OR                                                                                                                                                                                       */
  Bin_InCh_to_TmpVar(VOR, 1)                                                                                  /*     "                                                                                                                                                                                       */
  APatternT1(88,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyNLEDs(2, 89, Zeit2, 88)                                                                                 /* V(OR)                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* (N)ACH                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(NACH, 1)                                                                                 /*     "                                                                                                                                                                                       */
  APatternT1(91,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                         /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 92, Zeit2, 91)                                                                                 /* N(ACH)                                                                                                                                                                                      */
  // Set_LEDNr(107)                                                                                           /* Excel row 206                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* HAL(B)                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(HALB, 1)                                                                                 /*     "                                                                                                                                                                                       */
  APatternT1(107,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 108, Zeit2, 107)                                                                               /* (HAL)B                                                                                                                                                                                      */
  // Set_LEDNr(100)                                                                                           /* Excel row 213                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* N(F)                                                                                                                                                                                       */
  Bin_InCh_to_TmpVar(STD_UENF, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(100,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(2, 101, Zeit2, 100)                                                                               /* (N)F                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* F                                                                                                                                                                                           */
  Bin_InCh_to_TmpVar(STD_F, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(103,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* E(L)                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(STD_EL, 1)                                                                               /*     "                                                                                                                                                                                       */
  APatternT1(104,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyLED(105, Zeit2, 104)                                                                                    /* (E)L                                                                                                                                                                                        */
  // Set_LEDNr(115)                                                                                           /* Excel row 222                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (E)IN                                                                                                                                                                                       */
  Bin_InCh_to_TmpVar(STD_EIN, 1)                                                                              /*     "                                                                                                                                                                                       */
  APatternT1(115,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(2, 116, Zeit2, 115)                                                                               /* E(IN)                                                                                                                                                                                       */
  Logic(STD_S, NOT VolleStd AND STD_EIN)                                                                      /* Excel row 226                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* EIN(S)                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(STD_S, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(118,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Set_LEDNr(122)                                                                                           /* Excel row 229                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (Z)WEI                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(STD_ZWEI, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(122,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 123, Zeit2, 122)                                                                               /* Z(WEI)                                                                                                                                                                                      */
  // Set_LEDNr(135)                                                                                           /* Excel row 233                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* VIE(R)                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(STD_VIER, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(135,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 136, Zeit2, 135)                                                                               /* (VIE)R                                                                                                                                                                                      */
  // Activation: Binary                                                                                       /* DER(I)                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(STD_DREI, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(139,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 140, Zeit2, 139)                                                                               /* (DRE)I                                                                                                                                                                                      */
  // Set_LEDNr(150)                                                                                           /* Excel row 240                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (S)ECHS                                                                                                                                                                                     */
  Bin_InCh_to_TmpVar(STD_SECHS, 1)                                                                            /*     "                                                                                                                                                                                       */
  APatternT1(150,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(4, 151, Zeit2, 150)                                                                               /* S(ECHS)                                                                                                                                                                                     */
  // Activation: Binary                                                                                       /* (A)CHT                                                                                                                                                                                      */
  Bin_InCh_to_TmpVar(STD_ACHT, 1)                                                                             /*     "                                                                                                                                                                                       */
  APatternT1(155,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(3, 156, Zeit2, 155)                                                                               /* A(CHAT)                                                                                                                                                                                     */
  // Set_LEDNr(163)                                                                                           /* Excel row 247                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* ZWL(F)                                                                                                                                                                                     */
  Bin_InCh_to_TmpVar(STD_ZWOELF, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(163,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(4, 164, Zeit2, 163)                                                                               /* (ZWL)F                                                                                                                                                                                     */
  // Set_LEDNr(179)                                                                                           /* Excel row 251                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (Z)EH                                                                                                                                                                                       */
  Bin_InCh_to_TmpVar(STD_ZEH, 1)                                                                              /*     "                                                                                                                                                                                       */
  APatternT1(179,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(2, 180, Zeit2, 179)                                                                               /* Z(EH)                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* (N)                                                                                                                                                                                         */
  Bin_InCh_to_TmpVar(STD_N, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(182,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* (E)UN                                                                                                                                                                                       */
  Bin_InCh_to_TmpVar(STD_EUN, 1)                                                                              /*     "                                                                                                                                                                                       */
  APatternT1(183,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(2, 184, Zeit2, 183)                                                                               /* E(UN)                                                                                                                                                                                       */
  // Set_LEDNr(197)                                                                                           /* Excel row 260                                                                                                                                                                               */
  Logic(Uhr_Txt, Zeit1 AND VolleStd)                                                                          /* Excel row 261                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* UH(R)                                                                                                                                                                                       */
  Bin_InCh_to_TmpVar(Uhr_Txt, 1)                                                                              /*     "                                                                                                                                                                                       */
  APatternT1(197,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(2, 198, Zeit2, 197)                                                                               /* (UH)R                                                                                                                                                                                       */
  // Set_LEDNr(201)                                                                                           /* Excel row 265                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* SIEBE(N)                                                                                                                                                                                    */
  Bin_InCh_to_TmpVar(STD_SIEBEN, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(201,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyNLEDs(5, 202, Zeit2, 201)                                                                               /* (SIEBE)N                                                                                                                                                                                    */
  New_HSV_Group()                                                                                             /* Die Wochentage haben eine andere Farbe                                                                                                                                                      */
  XPatternT5(207,28,SI_LocalVar,1,0,255,0,PM_HSV,1 ms,30 Sek,0 ms,60 Sek,0 ms,127,255,0,255,0  ,0,0,0,64,1)   /* HSV_Farbe_mit_Startwert (pc)                                                                                                                                                                */
  APatternT1(207,194,SI_0,1,0,1,0,PM_HSV|PF_EASEINOUT,1 Sek,1)                                                /* Die Erste LED fr Wochentage                                                                                                                                                                */
  // Set_LEDNr(211)                                                                                           /* Excel row 275                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (M)I                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Wochentag4, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(211,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyLED(212, Zeit2, 211)                                                                                    /* M(I)                                                                                                                                                                                        */
  // Activation: Binary                                                                                       /* (S)A                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Wochentag7, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(213,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyLED(214, Zeit2, 213)                                                                                    /* S(A)                                                                                                                                                                                        */
  // Activation: Binary                                                                                       /* (F)R                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Wochentag6, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(215,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyLED(216, Zeit2, 215)                                                                                    /* F(R)                                                                                                                                                                                        */
  // Activation: Binary                                                                                       /* (D)I                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Wochentag3, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(217,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyLED(218, Zeit2, 217)                                                                                    /* D(I)                                                                                                                                                                                        */
  // Activation: Binary                                                                                       /* (S)O                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Wochentag1, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(219,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  CopyLED(220, Zeit2, 219)                                                                                    /* S(O)                                                                                                                                                                                        */
  // Activation: Binary                                                                                       /* (D)O                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Wochentag5, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(221,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  Logic(O_Do_or_Mo, Wochentag5 OR Wochentag2)                                                                 /* Excel row 292                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* D(O) oder M(O)                                                                                                                                                                              */
  Bin_InCh_to_TmpVar(O_Do_or_Mo, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(222,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Set_LEDNr(195)                                                                                           /* Excel row 295                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* (M)O                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Wochentag2, 1)                                                                           /*     "                                                                                                                                                                                       */
  APatternT1(195,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Set_LEDNr(227)                                                                                           /* Excel row 302                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* 29C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp12, 1)                                                                               /*     "                                                                                                                                                                                       */
  APatternT1(227,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 28C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp11, 1)                                                                               /*     "                                                                                                                                                                                       */
  APatternT1(228,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 27C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp10, 1)                                                                               /*     "                                                                                                                                                                                       */
  APatternT1(229,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 26C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp9, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(230,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 25C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp8, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(231,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 24C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp7, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(232,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 23C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp6, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(233,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 22C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp5, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(234,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 21C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp4, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(235,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 20C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp3, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(236,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 19C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp2, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(237,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */
  // Activation: Binary                                                                                       /* 18C                                                                                                                                                                                        */
  Bin_InCh_to_TmpVar(Temp1, 1)                                                                                /*     "                                                                                                                                                                                       */
  APatternT1(238,130,SI_LocalVar,1,0,255,0,PM_HSV|PF_EASEINOUT,1 Sek,14  ,63,128,64,1)                        /*     "                                                                                                                                                                                       */

  EndCfg // End of the configuration
  };
//*******************************************************************

#ifndef COPYLED_OFF
#define COPYLED_OFF 0
#endif

#ifndef COPYLED_OFF_ONCE
#define COPYLED_OFF_ONCE 1
#endif

//---------------------------------------------
void Set_Start_Values(MobaLedLib_C &MobaLedLib)
//---------------------------------------------
{
}


// if function returns TRUE the calling loop stops
typedef bool(*HandleValue_t) (uint8_t CallbackType, uint8_t ValueId, uint8_t* Value, uint16_t EEPromAddr, uint8_t TargetValueId, uint8_t Options);


#define InCnt_MSK  0x003F  // 6 bits are used for the InCnt, 2 bits for the type ttcc cccc => Max InCnt=63
#define IS_COUNTER (uint8_t)0x80
#define IS_PULSE   (uint8_t)0x40
#define IS_TOGGLE  (uint8_t)0x00
#define COUNTER_ID

typedef struct
    {
    uint8_t TypAndInCnt; // Type bits 7 & 6, InCnt 0..5
    uint8_t Channel;
    } __attribute__ ((packed)) Store_Channel_T;

// Definition of channels and counters that need to store state in EEProm
const PROGMEM Store_Channel_T Store_Values[] =
         { // Mode + InCnt , Channel
           { IS_PULSE  + 4 , Minutes0            },      // Minuten viertel vor (Nur eine der 3 Zeilen darf aktiv sein)
           { IS_PULSE  + 4 , Hours0              },      // Stunden normale Zeile
         };

#ifndef CONFIG_ONLY
// ----- dynamic extensions section begin -----
#include <MLLExtension.h>

// Extension WordClock_LDR_Extension
#include <WordClock_LDR_MLX.h>

// Extension WordClock_MotionDetect_Extention
#include <WordClock_MotionDetect_MLX.h>

// Extension RealTimeClockExtension
#include <RealTimeClockMLX.h>

// Extension WordClockTextExtension
#include <WordClockTextMLX.h>


// ----- dynamic extensions section begin -----
MLLExtension* mllExtensions[] = {
  new WordClock_LDR(35, 1500, 280, 20, 255, 0.05),
  new WordClock_MotionDetect(10 Min, 33, 14),
  new RT_Clock(SI_1, RTC_CONTR_VAR, 0, Zeit0, Zeit3),
  new RT_Clock(SwitchD1, RTC_DAYOFYEAR, "09.8. 9.8. 11.8. 12.8.", Birthday1, Birthday4),
  new WordClockText(Birthday1, "HALLO JRGEN WIE GEHT ES DIR "),
  new WordClockText(Birthday2, "TEST "),
  new WordClockText(Birthday4, "...H.E..R.Z...L..ICH.EN GLCKWUNSCH"),
  new RT_Clock(SwitchD2, RTC_DAYOFYEAR, "0.0. 0.0. 0.0. 0.0.", EventTxt1, EventTxt4),
  new WordClockText(EventTxt1, ".....STUMMI_.FORUM "),
  new WordClockText(EventTxt2, "MOBA_...LED_LIB"),
  new WordClockText(EventTxt3, ".....RGB_....LED"),
  new WordClockText(EventTxt4, ".BY JRGEN UND HARDI"),
  new RT_Clock(Zeit0, RTC_OFF, 0, UnusedVar0, UnusedVar0),
  new RT_Clock(0, RTC_5MIN_OFFS , 0, MinOffs0, MinOffs4),
  new RT_Clock(1, RTC_5MIN , 0, Minutes0, Minutes3),
  new RT_Clock(2, RTC_HOUR_WC1, 0, Hours0, Hours3),
  new RT_Clock(3, RTC_WDAY | RTC_SINGLE, 0, Wochentag0, Wochentag7),
  new RT_Clock(4, RTC_TEMP_WC + RTC_SINGLE, 0, Temp0, Temp12)
} ;
#define MLL_EXTENSIONS_COUNT 18

// ----- dynamic Extensions section end -----

#endif // CONFIG_ONLY





#endif // __LEDS_AUTOPROG_H__
